/* Trang web Đại Tạng Kinh được lập trình bởi Xuân Duật và đây là mã nguồn mở */

var audioIds = null, audioDatas = null, audioDialect = 'nam', audioIndex = null, audioNextId = null, audioMode = 'pause', audioAutoPlay = false, audioDelay = 0;

function audioInit()
{
	var a = [];
	audioIndex = null;  audioNextId = null; audioMode = 'pause'; audioDelay = 0;
	for(var i = 0; i < audioIds.length; i++)
	{
		var n = audioIds[i];
		if(n != 0)
		{
			//obj('a' + i).style.fontSize = '0.95em';
			obj('a' + i).onclick = function()
			{
				dict(encodeURIComponent(this.innerHTML));
			}
			/*keep this for future onmouseup
			obj('a' + i).ontouchstart = function(startEvent)
			{
				var tmp = startEvent.getBoundingClientRect().top;
				this.ontouchend = function(endEvent)
				{
					if(tmp == endEvent.target.getBoundingClientRect().top)
						this.onmousedown();
				}
			}
			*/
		}
	}
	//if(getvidialect() == 'bac') audioDialect = 'bac';
	innerHTML('audiox', '<div id=audio style="-webkit-backface-visibility: hidden; position:fixed; left: 0; bottom: 0; z-index:10002; font-size:50%;"><span id=progress></span><a id=btn class=box2 href="javascript:void(0);" onclick="audioAction(); return false;">►</a></div><div id=soundPreload style="display:none;"></div>');
	audioBtnAdjust();
	
	if(audioAutoPlay)
	{
		obj('popup').scrollTo(0, 0);
		audioAutoPlay = false;
		audioPlay();
	}
}
function audioLoad()
{
	hide('btn'); show('progress');
	var xmlhttp = new XMLHttpRequest();
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
		{
			audioDatas = JSON.parse(xmlhttp.responseText);
			show('btn'); hide('progress');
			
			audioPlay();
			var tmp = audioIndex;
			setTimeout(function()
			{
				if(tmp == audioIndex)
				{
					audioPause();
					show('progress'); innerHTML('progress', 'bấm!');
				}
			}, 2000);
		}
	}
	
	xmlhttp.addEventListener('progress', function(e)
	{
		if (e.lengthComputable) innerHTML('progress', Math.round(e.loaded / e.total * 100) + '<sup>%</sup>');
	});

	xmlhttp.open('GET', 'a/' + audioDialect + '-' + audioType + '.json', true);
	xmlhttp.send();
}
function audioAt(index)
{
	audioIndex = index;
	var id = audioIds[audioIndex];
	if(id == 0)
	{
		audioNextId = setTimeout(audioNext, 400);
	}
	else
	{
		audioDelay = 0;
		var length = 0;
		
		length = audioDatas[id].length;
		
		if(length < 9700)
		{
			//min: 6580,  max: 12784, 9700
			audioDelay = parseInt((9700 - length) / 30);
		}
		
		audio.src = 'data:audio/' + audioType + ';base64,' + audioDatas[id];
		
		audioNextId = setTimeout(function()
		{
			audio.addEventListener('ended', audioEnded);
			audio.play();
			var o = obj('a' + audioIndex);
			if(!isElementInViewport(o)) o.scrollIntoView();
			o.style.color = 'red';
		}, audioDelay);
	}
}
function audioEnded()
{
	audioNextId = setTimeout(function()
	{
		audioReset();
		audioNext();
	}, audioDelay);
}
function audioNext()
{
	if(audioIndex == audioIds.length - 1)
		audioComplete();
	else
		audioAt(audioIndex + 1);
}
function audioFindNext()
{
	for(var i = 0; i < audioIds.length; i++)
	{
		var n = audioIds[i];
		if(n != 0 && isElementInViewport(obj('a' + i)))
		{
			audioAt(i);
			break;
		}
	}
}
function audioPlay()
{
	hide('progress');
	audioMode = 'play';
	innerHTML('btn', '&nbsp;ll&nbsp;');
	obj('btn').style.opacity = 0.5;
	
	if(audioIndex == null)
		audioFindNext();
	else if(audioIds[audioIndex] != 0 && isElementInViewport(obj('a' + audioIndex)))
		audioAt(audioIndex);
	else if(audioIds[audioIndex] == 0)
	{
		var n = audioIndex;
		while(n < audioIds.length - 1 && audioIds[n] == 0)
		{
			n++;
		}
		if(n < audioIds.length - 1 && audioIds[n] != 0 && isElementInViewport(obj('a' + n)))
			audioAt(n);
		else
			audioFindNext();
	}
	else
		audioFindNext();
}
function audioPause()
{
	audioReset();
	audioMode = 'pause';
	innerHTML('btn', '►');
	obj('btn').style.opacity = 1;
}
function audioAction()
{
	if(audioDatas == null)
		audioLoad();
	else if(audioMode == 'pause')
		audioPlay();
	else
		audioPause();
}
function audioReset()
{
	audio.removeEventListener('ended', audioEnded);
	clearTimeout(audioNextId);
	if(audioIndex != null && audioIds[audioIndex] != 0)
	{
		obj('a' + audioIndex).style.color = '#006597';
	}
}
function audioExit()
{
	if(audioIndex == null) return;
	clearTimeout(audioNextId);
	audio.pause();
	audio.removeEventListener('ended', audioEnded);
}
function audioComplete()
{
	if(elementExist('book0'))
	{
		var book = 0;
		var curr = 0;
		var next = 0;
		var val = true;
		while(val || book > 600)
		{
			var id = 'book' + book;
			if(elementExist(id))
			{
				if(obj(id).className == 'boxc')
					curr = book;
				book++;
			}
			else
			{
				val = false;
				break;
			}
		}
		if(curr < (book-1)) next = curr + 1;
		audioAutoPlay = true;
		obj('book' + next).onclick();
	}
	else
	{
		audioAt(0);
	}
}